<?php
/* --------------------------------------------------------------
   StorageOfSingleParcelServiceRequested.php 2020-03-25
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\ParcelService\Events;

use Gambio\Admin\ParcelService\Interfaces\ParcelService;

/**
 * Class StorageOfSingleParcelServiceRequested
 *
 * @package Gambio\Admin\ParcelService\Events
 */
class StorageOfSingleParcelServiceRequested
{
    /**
     * @var ParcelService
     */
    private $parcelService;
    
    
    /**
     * StorageOfSingleParcelServiceRequested constructor.
     *
     * @param ParcelService $parcelService
     */
    private function __construct(ParcelService $parcelService)
    {
        $this->parcelService = $parcelService;
    }
    
    
    /**
     * @param ParcelService $parcelService
     *
     * @return StorageOfSingleParcelServiceRequested
     */
    public static function create(ParcelService $parcelService): StorageOfSingleParcelServiceRequested
    {
        return new self($parcelService);
    }
    
    
    /**
     * @return ParcelService
     */
    public function parcelService(): ParcelService
    {
        return $this->parcelService;
    }
    
    
    /**
     * @param ParcelService $parcelService
     */
    public function replaceParcelService(ParcelService $parcelService): void
    {
        $this->parcelService = $parcelService;
    }
}